<?php

class db extends mysqli
{
    private static $instance;

    public static function Instance()
    {
        if (self::$instance == null)
            self::$instance = new db(DB_HOSTNAME, DB_USERNAME, DB_PASSWORD, DB_NAME);
        return self::$instance;
    }

    //FUNCTION SELECT
    //GET ONE PARAMETER - QUERY
    //RETURN ASSOC ARRAY - arr
    public function select($query){
        //print $query;
        $arr = array();
        if($result = parent::query($query)){
            while ($row = $result->fetch_assoc()){
                $arr[] = $row;
            }
            return $arr;
        }
    }


    //FUNCTION SELECT
    //GET ONE PARAMETER - QUERY
    //RETURN ASSOC ARRAY - arr
    public function select_result_array($query, $return){
        //print $query;
        $arr = array();
        if($result = parent::query($query)){
            while ($row = $result->fetch_assoc()){
                $arr[] = $row[$return];
            }
            return $arr;
        }
    }

    //FUNCTION SELECTOne
    //GET ONE PARAMETER - QUERY
    //RETURN ASSOC ARRAY - arr
    public function selectOne($query){
        //print $query;
        $arr = array();
        if($result = parent::query($query)){
            while ($row = $result->fetch_assoc()){
                $arr[] = $row;
            }
            if(!empty($arr[0])) return $arr[0]; else return null;
        }
    }

    //
    //FUNCTION INSERT
    //GET TWO PARAMETERS - TABLE NAME, ARRAY OF KEYS => VALUES
    //RETURN TRUE OR ERROR
    public function insert($tableName, $keyValue){
        $columns = array();
        $values  = array();
        foreach ($keyValue as $key => $value){
            $columns[] = "`".$this->real_escape_string($key)."`";

            if($value === null){
                $values[] = "NULL";
            }
            else{
                $value = $this->real_escape_string(htmlspecialchars(trim($value)));
                $values[] = "'$value'";
            }
        }

        $columnsQuery = implode(',', $columns);
        $valuesQuery  = implode(',', $values);

        $query = "INSERT INTO $tableName ($columnsQuery) VALUES ($valuesQuery)";

        if(!$this->query($query)){
            return false;
        }
        else return true;
    }

    //
    //FUNCTION UPDATE
    //GET THREE PARAMETERS - TABLE NAME, ARRAY OF KEYS => VALUES, ID
    //RETURN TRUE OR ERROR
    public function update($tableName, $keyValue, $id, $column = 'id'){
        $sets = array();
        foreach ($keyValue as $key => $value){
            $key = "`".$this->real_escape_string($key)."`";
            if($value === null){
                $values[] = "NULL";
            }
            else{
                $value = $this->real_escape_string(htmlspecialchars(trim($value)));
            }
            $sets[] = "$key = '$value'";
        }
        $setsQuery = implode(',', $sets);

        $query = "UPDATE $tableName SET $setsQuery WHERE $column = '$id'";
        //print $query;die();
        if(!$this->query($query)){
            return false;
        }
        else
            return true;
    }


    //
    //FUNCTION DELETE
    //GET TWO PARAMETERS - TABLE NAME, ID
    //RETURN TRUE OR ERROR
    public function delete($tableName, $id, $column = 'id'){
        $id = (int)$id;
        $query = "DELETE FROM $tableName WHERE `" . $column . "` = '$id'";
        if(!$this->query($query)){
            return false;
        }
        else
            return true;
    }


    public function clearInput($str)
    {
        $str = htmlspecialchars( $this->real_escape_string(trim($str) ) );
        return $str;
    }

    public function mysqlDate($str)
    {
        return date('Y-m-d H:i:s', strtotime($str));
    }

    public function mysqlDateNow()
    {
        return date('Y-m-d H:i:s');
    }


    public function humanCount($count){
        if($count >= 1000000) $count = $count/1000000 . 'm';
        elseif($count >= 1000) $count = $count/1000 . 'k';

        return $count;
    }
}


